/*
 * Vuln Title: XXXX
 *
 * Copyright (C) 2005-2010 Sourcefire, Inc. All Rights Reserved
 *
 * Written by XXXX, Sourcefire VRT <XXXX@sourcefire.com>
 *
 * Auto-generated by XXXX
 *
 * This file may contain proprietary rules that were created, tested and
 * certified by Sourcefire, Inc. (the "VRT Certified Rules") as well as
 * rules that were created by Sourcefire and other third parties and
 * distributed under the GNU General Public License (the "GPL Rules").  The
 * VRT Certified Rules contained in this file are the property of
 * Sourcefire, Inc. Copyright 2005 Sourcefire, Inc. All Rights Reserved.
 * The GPL Rules created by Sourcefire, Inc. are the property of
 * Sourcefire, Inc. Copyright 2002-2005 Sourcefire, Inc. All Rights
 * Reserved.  All other GPL Rules are owned and copyrighted by their
 * respective owners (please see www.snort.org/contributors for a list of
 * owners and their respective copyrights).  In order to determine what
 * rules are VRT Certified Rules or GPL Rules, please refer to the VRT
 * Certified Rules License Agreement.
 */

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif

/* declare detection functions */
int rule20135eval(void *p);

/* declare rule data structures */
/* flow:established, to_server; */
static FlowFlags rule20135flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule20135option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule20135flow0
    }
};
// content:"|FF FE|2|00 00 00|", offset 4, depth 6, fast_pattern; 
static ContentInfo rule20135content1 = 
{
    (uint8_t *) "|FF FE 32 00 00 00|", /* pattern (now in snort content format) */
    6, /* depth */
    4, /* offset */
    CONTENT_FAST_PATTERN|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20135option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20135content1
    }
};
// content:"2|00|7|00 00 00|", depth 6, relative; 
static ContentInfo rule20135content2 = 
{
    (uint8_t *) "|20 00 32 00 37 00 00 00|", /* pattern (now in snort content format) */
    8, /* depth */
    0, /* offset */
    /*CONTENT_FAST_PATTERN|*/CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED, /* flags */
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule20135option2 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule20135content2
    }
};

/* references for sid 20135 */
/* reference: bugtraq "48486"; */
static RuleReference rule20135ref1 = 
{
    "bugtraq", /* type */
    "48486" /* value */
};

/* reference: cve "2011-1865"; */
static RuleReference rule20135ref2 = 
{
    "cve", /* type */
    "2011-1865" /* value */
};

static RuleReference *rule20135refs[] =
{
    &rule20135ref1,
    &rule20135ref2,
    NULL
};
/* metadata for sid 20135 */
/* metadata:policy security-ips drop; */

static RuleMetaData rule20135policy1 = 
{
    "policy security-ips drop"
};


static RuleMetaData *rule20135metadata[] =
{
    &rule20135policy1,
    NULL
};

RuleOption *rule20135options[] =
{
    &rule20135option0,
    &rule20135option1,
    &rule20135option2,
    NULL
};

Rule rule20135 = {
   /* rule header, akin to => tcp any any -> any any */
   {
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "5555", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid */
       20135, /* sigid */
       2, /* revision */
       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SERVER-OTHER HP OpenView Storage Data Protector buffer overflow attempt",     /* message */
       rule20135refs /* ptr to references */
       ,rule20135metadata
   },
   rule20135options, /* ptr to rule options */
   &rule20135eval, /* ptr to rule detection function, due to relative pcre */
   0 /* am I initialized yet? */
};


/* detection functions */
const uint8_t * find_unicode_null(const uint8_t *cursor, const uint8_t *end_of_payload) {

   while(cursor + 2 <= end_of_payload) {
      if(!(*((const uint16_t *)cursor))) {
         DEBUG_SO(printf("Unicode NULL found at location %p\n", cursor);)
         return(cursor + 2); // +2 to include the length of the NULL
      }

      cursor += 2;
   }

   DEBUG_SO(printf("No Unicode NULL found!\n");)
   return((const uint8_t *)NULL);
}

int rule20135eval(void *p) {
   const uint8_t *cursor_normal = 0, *end_of_payload = NULL;
   const uint8_t *string3 = NULL;
   SFSnortPacket *sp = (SFSnortPacket *) p;

   DEBUG_SO(printf("rule20135eval enter\n");)

   if(sp == NULL)
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_server;
   if(checkFlow(p, rule20135options[0]->option_u.flowFlags) <= 0 ) {
      return RULE_NOMATCH;
   }

   // We need end_of_payload later
   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0) {
      DEBUG_SO(fprintf(stderr, "getBuffer failed\n"));
      return RULE_NOMATCH;
   }

   // content:"|FF FE 32 00 00 00|", offset 4, depth 6, fast_pattern;
   if(contentMatch(p, rule20135options[1]->option_u.content, &cursor_normal) <= 0) {
      DEBUG_SO(fprintf(stderr, "string0 match failed\n"));
      return RULE_NOMATCH;
   }    

   // jump over all of the unicode strings to get what we need.
   // Jump over the first string.
   if(!(cursor_normal = find_unicode_null(cursor_normal, end_of_payload))) {
      DEBUG_SO(printf("Unable to find string2\n");)
      return RULE_NOMATCH;
   }

   // Jump over the second string, store pointer to the third string for later
   if(!(string3 = find_unicode_null(cursor_normal, end_of_payload))) {
      DEBUG_SO(printf("Unable to find string3\n");)
      return RULE_NOMATCH;
   }
 
   // Jump over the third string 
   if(!(cursor_normal = find_unicode_null(string3, end_of_payload))) {
      DEBUG_SO(printf("Unable to find string4\n");)
      return RULE_NOMATCH;
   }

   // Jump over the fourth string, then use the pointer to the fifth string
   if(!(cursor_normal = find_unicode_null(cursor_normal, end_of_payload))) {
      DEBUG_SO(printf("Unable to find string5\n");)
      return RULE_NOMATCH;
   }

   // This is the vulnerable condition: len(string3 + string4) is longer than 254.
   // (cursor_normal points to the start of the fifth string, or end of the fourth)
   if(((cursor_normal - string3) / 2) < 254) {
      return RULE_NOMATCH;
   }

   // Now that we MAY be finding a vulnerable condition, check string6.

   // Jump over the fifth string to get to the sixth
   if(!(cursor_normal = find_unicode_null(cursor_normal, end_of_payload))) {
      DEBUG_SO(printf("Unable to find cursor_normal\n");)
      return RULE_NOMATCH;
   }

   // Make sure string6 has the correct value
   if(contentMatch(p, rule20135options[2]->option_u.content, &cursor_normal) > 0) {
      DEBUG_SO(printf("string6 is what we expect!\n");)
      return RULE_MATCH;
   }    
   
   DEBUG_SO(printf("string6 didn't match\n");)
   return RULE_NOMATCH;
}
